#!/bin/bash

remoteTar=$1

if [ -z "$remoteTar" ]; then
    echo "❌ Error: Debes especificar la ruta del archivo tar."
    exit 1
fi

echo "🚀 Iniciando despliegue..."

echo "🧹 Limpiando instalación anterior..."
sudo rm -rf /home/pi/app

echo "📂 Creando directorio de destino..."
mkdir -p /home/pi/app

echo "📦 Descomprimiendo (eliminando la carpeta contenedora 'app')..."
# --strip-components=1 elimina la primera carpeta del tar (app/) al extraer
tar -xzf "${remoteTar}" -C /home/pi/app --strip-components=1

echo "🗑️ Eliminando el archivo comprimido..."
rm "${remoteTar}"

echo "🔒 Asignando permisos..."
chmod +x /home/pi/app/my-app

echo "🔄 Reiniciando servicios..."
sudo systemctl daemon-reload
sudo systemctl start kiosk.service
sudo systemctl start kiosk-app.service

echo "✅ Listo. Estructura final: /home/pi/app/my-app"